#define LIGHTING
#include "InventorBasicEffectDx9.fxh"

struct VSPosNormColTex
{
	float3 Pos			: Position;
	float3 Norm			: Normal;
	float4 Col			: Color;
	float2 Tex			: TexCoord;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------

VSOutput VS_PosNormColTex( VSPosNormColTex Input)
{
	VSOutput Out = (VSOutput) 0;
	float4 LocalPos = float4(Input.Pos,1.0f);
	Out.Pos = mul(LocalPos, g_matWorldViewProj);
	float3 ViewPos = mul(LocalPos, g_matWorldView);    //position in view space
	float3 Viewer = -normalize(ViewPos);                   //viewer
	float3 ViewNormal = mul(Input.Norm, (float3x3)g_matWorldViewIT);//normal in view space
	ViewNormal = normalize(ViewNormal);

#ifdef DIFFUSE_TEXTURE	
	Out.Tex = float4(Input.Tex, 0, 1.0f);
#endif 

#ifdef ENVIRONMENT_TEXTURE
	float3 VwNorm = normalize(mul(Viewer, (float3x3)transpose(g_matView)));
	float3 Nw = normalize(mul(ViewNormal, (float3x3)transpose(g_matView)));	
	Out.EnvTex = float4(2.f * dot(VwNorm,Nw) * Nw - VwNorm, 1.0f);
#endif
	
	float4 Emissive = float4(0,0,0,0);
	float4 Ambient = Input.Col;
	float4 Diffuse = Input.Col;
	float4 Specular = float4(0,0,0,0);
	float Glossness = 0;
	float Opacity = Input.Col.a;
	TripleColor Color = CalcLighting(Input.Pos, Viewer, ViewNormal, Emissive, Ambient, Diffuse, Specular, Glossness, Opacity
#ifdef SHADOWS
        , Out.ShadowD, Out.ShadowS
#endif
        );
	Out.ColorD = Color.Diffuse;
	Out.ColorSAndFogFactor.xyz = Color.Specular.xyz; 	
		
#ifdef SHADOWS
    Out.ShadowPos = LocalPos;
#endif

	if(g_fogEnabled)
	{
		Out.ColorSAndFogFactor.w = CalcFogFactor(ViewPos.z);
	}

	return Out;
}

//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------

float4 PS_PosNormColTex( PSInput Input ) : COLOR0
{
#ifdef SHADOWS
		Input.ShadowPos = mul(mul(Input.ShadowPos, g_matWorld), gShadowMapXf);
    	float shadowFactor = SampleShadowMap(Input.ShadowPos);
    	Input.ColorD += Input.ShadowD * (1.0f - (1.0f - shadowFactor) * gShadowDensity);
    	Input.ColorSAndFogFactor.xyz += Input.ShadowS * (1.0f - (1.0f - shadowFactor) * gShadowDensity);
#endif

#ifdef	DIFFUSE_TEXTURE
	Input.Tex = mul(Input.Tex, g_matDiffTex);
	CalcDiffuseTexture(Input);
#endif

#ifdef ENVIRONMENT_TEXTURE	
	Input.EnvTex = mul(Input.EnvTex, g_matEnvTex);
	CalcEnvironmentTexture(Input,g_Specular,g_Misc.z);
#endif
	
	if(Input.ColorD.a < g_Misc.w)
		discard;

	float4 Color=(float4)0;
	Color.xyz = saturate(Input.ColorD.xyz + Input.ColorSAndFogFactor.xyz);
	Color.a = Input.ColorD.a;

	if(g_fogEnabled)
	{
		float FogFactor = Input.ColorSAndFogFactor.w;
		return FogFactor * Color + (1.0 - FogFactor) * g_fogColor;
	}
	else
		return Color;
}

//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------
technique PosNormColTex
{
    pass P0
    {  
#ifdef SHADERMODEL2 
		VertexShader = compile vs_2_0 VS_PosNormColTex();
		PixelShader = compile ps_2_0 PS_PosNormColTex();
#else
		VertexShader = compile vs_2_a VS_PosNormColTex();
		PixelShader = compile ps_2_a PS_PosNormColTex();
#endif
    }
}